/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class VhatiIlDalEffect
extends OneShotEffect {
    VhatiIlDalEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Until end of turn, target creature has base power 1 or base toughness 1";
    }

    private VhatiIlDalEffect(VhatiIlDalEffect effect) {
        super((OneShotEffect)effect);
    }

    public VhatiIlDalEffect copy() {
        return new VhatiIlDalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            StaticValue power = null;
            StaticValue toughness = null;
            if (controller.chooseUse(this.outcome, "Set power? (otherwise toughness is set)", source, game)) {
                power = StaticValue.get((int)1);
            } else {
                toughness = StaticValue.get((int)1);
            }
            SetBasePowerToughnessTargetEffect effect = new SetBasePowerToughnessTargetEffect((DynamicValue)power, (DynamicValue)toughness, Duration.EndOfTurn);
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

