/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ViashinoSandswimmerEffect
extends OneShotEffect {
    ViashinoSandswimmerEffect() {
        super(Outcome.Damage);
        this.staticText = "Flip a coin. If you win the flip, return {this} to its owner's hand. If you lose the flip, sacrifice {this}";
    }

    private ViashinoSandswimmerEffect(ViashinoSandswimmerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null) {
            if (controller.flipCoin(source, game, true)) {
                new ReturnToHandSourceEffect().apply(game, source);
                return true;
            }
            new SacrificeSourceEffect().apply(game, source);
            return true;
        }
        return false;
    }

    public ViashinoSandswimmerEffect copy() {
        return new ViashinoSandswimmerEffect(this);
    }
}

