/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;
import mage.watchers.common.AbilityResolvedWatcher;

class VictorValgavothsSeneschalEffect
extends OneShotEffect {
    VictorValgavothsSeneschalEffect() {
        super(Outcome.Benefit);
        this.staticText = "If it's the third time, put a creature card from a graveyard onto the battlefield under your control";
    }

    private VictorValgavothsSeneschalEffect(VictorValgavothsSeneschalEffect effect) {
        super((OneShotEffect)effect);
    }

    public VictorValgavothsSeneschalEffect copy() {
        return new VictorValgavothsSeneschalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (AbilityResolvedWatcher.getResolutionCount((Game)game, (Ability)source) != 3) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        target.withNotTarget(true);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

