/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class VigilForTheLostEffect
extends OneShotEffect {
    VigilForTheLostEffect() {
        super(Outcome.GainLife);
        this.staticText = "pay {X}. If you do, you gain X life";
    }

    private VigilForTheLostEffect(VigilForTheLostEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int costX = controller.announceX(0, Integer.MAX_VALUE, "Announce the value for {X} (pay to gain life)", game, source, true);
        if (new GenericManaCost(costX).pay(source, game, source, source.getControllerId(), false, null)) {
            controller.gainLife(costX, game, source);
            return true;
        }
        return false;
    }

    public VigilForTheLostEffect copy() {
        return new VigilForTheLostEffect(this);
    }
}

