/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.v.VigorousChargeTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class VigorousChargeEffect
extends OneShotEffect {
    VigorousChargeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Whenever that creature deals combat damage this turn, if this spell was kicked, you gain life equal to that damage.";
    }

    private VigorousChargeEffect(VigorousChargeEffect effect) {
        super((OneShotEffect)effect);
    }

    public VigorousChargeEffect copy() {
        return new VigorousChargeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new VigorousChargeTriggeredAbility(new MageObjectReference((MageObject)permanent, game)), source);
        return true;
    }
}

