/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class VillageCannibalsTriggeredAbility
extends TriggeredAbilityImpl {
    public VillageCannibalsTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()));
        this.setTriggerPhrase("Whenever another Human creature dies, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private VillageCannibalsTriggeredAbility(VillageCannibalsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public VillageCannibalsTriggeredAbility copy() {
        return new VillageCannibalsTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!zEvent.isDiesEvent()) {
            return false;
        }
        Permanent permanent = (Permanent)game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD);
        return permanent != null && permanent.isCreature(game) && permanent.hasSubtype(SubType.HUMAN, game) && !permanent.getId().equals(this.getSourceId());
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

