/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ViridianRevelTriggeredAbility
extends TriggeredAbilityImpl {
    ViridianRevelTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), true);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private ViridianRevelTriggeredAbility(ViridianRevelTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ViridianRevelTriggeredAbility copy() {
        return new ViridianRevelTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (((ZoneChangeEvent)event).isDiesEvent()) {
            Permanent card = game.getPermanentOrLKIBattlefield(event.getTargetId());
            Player controller = game.getPlayer(this.getControllerId());
            if (controller != null && card != null && card.isArtifact(game) && controller.hasOpponent(card.getOwnerId(), game)) {
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever an artifact is put into an opponent's graveyard from the battlefield, you may draw a card.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

