/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class VisionsOfDreadEffect
extends OneShotEffect {
    VisionsOfDreadEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent puts a creature card of their choice from their graveyard onto the battlefield under your control";
    }

    private VisionsOfDreadEffect(VisionsOfDreadEffect effect) {
        super((OneShotEffect)effect);
    }

    public VisionsOfDreadEffect copy() {
        return new VisionsOfDreadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null || opponent.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) < 1) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD);
        target.withNotTarget(true);
        opponent.choose(Outcome.Detriment, (Target)target, source, game);
        return controller.moveCards(game.getCard(target.getFirstTarget()), Zone.BATTLEFIELD, source, game);
    }
}

