/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.cards.v.VislorTurloughGoadEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class VislorTurloughEffect
extends OneShotEffect {
    VislorTurloughEffect() {
        super(Outcome.Benefit);
        this.staticText = "have an opponent gain control of it. If you do, it's goaded for as long as they control it";
    }

    private VislorTurloughEffect(VislorTurloughEffect effect) {
        super((OneShotEffect)effect);
    }

    public VislorTurloughEffect copy() {
        return new VislorTurloughEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null) {
            return false;
        }
        TargetOpponent target = new TargetOpponent(0, 1, true);
        player.choose(Outcome.GainControl, (Target)target, source, game);
        Player opponent = game.getPlayer(target.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        game.addEffect(new GainControlTargetEffect(Duration.Custom, true, opponent.getId()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        game.addEffect((ContinuousEffect)new VislorTurloughGoadEffect(opponent.getId(), permanent, game), source);
        return true;
    }
}

