/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class ViviensArkbowEffect
extends OneShotEffect {
    ViviensArkbowEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Look at the top X cards of your library. You may put a creature card with mana value X or less from among them onto the battlefield. Put the rest on the bottom of your library in a random order.";
    }

    private ViviensArkbowEffect(ViviensArkbowEffect effect) {
        super((OneShotEffect)effect);
    }

    public ViviensArkbowEffect copy() {
        return new ViviensArkbowEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, xValue));
        player.lookAtCards(source, null, (Cards)cards, game);
        FilterCreatureCard filter = new FilterCreatureCard("creature card with mana value " + xValue + " or less");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xValue + 1));
        TargetCardInLibrary target = new TargetCardInLibrary(0, 1, (FilterCard)filter);
        if (player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game) && player.moveCards(card = game.getCard(target.getFirstTarget()), Zone.BATTLEFIELD, source, game)) {
            cards.remove(card);
        }
        return player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
    }
}

