/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapTargetCost;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackAbility;
import mage.watchers.Watcher;

class VodalianWarMachineWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<MageObjectReference>> tappedMerfolkIds = new HashMap<MageObjectReference, Set<MageObjectReference>>();

    VodalianWarMachineWatcher() {
        super(WatcherScope.GAME);
    }

    Set<MageObjectReference> getTappedMerfolkIds(Permanent permanent, Game game) {
        return this.tappedMerfolkIds.get(new MageObjectReference((MageObject)permanent, game));
    }

    public void watch(GameEvent event, Game game) {
        Ability ability;
        StackAbility stackAbility;
        Permanent sourcePermanent;
        if (event.getType() == GameEvent.EventType.ACTIVATED_ABILITY && event.getSourceId() != null && (sourcePermanent = game.getPermanentOrLKIBattlefield(event.getSourceId())) != null && (stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId())) != null && (ability = stackAbility.getStackAbility()) != null) {
            for (Cost cost : ability.getCosts()) {
                TapTargetCost tapCost;
                if (!(cost instanceof TapTargetCost) || !cost.isPaid() || !(tapCost = (TapTargetCost)cost).getTarget().isChosen(game)) continue;
                MageObjectReference mor = new MageObjectReference(sourcePermanent.getId(), sourcePermanent.getZoneChangeCounter(game), game);
                Set<Object> toAdd = this.tappedMerfolkIds.get(mor) == null ? new HashSet() : this.tappedMerfolkIds.get(mor);
                for (UUID targetId : tapCost.getTarget().getTargets()) {
                    toAdd.add(new MageObjectReference(targetId, game));
                }
                this.tappedMerfolkIds.put(mor, toAdd);
                break;
            }
        }
    }

    public void reset() {
        super.reset();
        this.tappedMerfolkIds.clear();
    }
}

