/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VoidEffect
extends OneShotEffect {
    VoidEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Choose a number. Destroy all artifacts and creatures with mana value equal to that number. Then target player reveals their hand and discards all nonland cards with mana value equal to the number";
    }

    private VoidEffect(VoidEffect effect) {
        super((OneShotEffect)effect);
    }

    public VoidEffect copy() {
        return new VoidEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int number = controller.getAmount(0, Integer.MAX_VALUE, "Choose a number (mana cost to destroy)", source, game);
        game.informPlayers(controller.getLogName() + " chooses " + number + '.');
        for (Permanent permanent : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            if (!permanent.isArtifact(game) && !permanent.isCreature(game) || permanent.getManaValue() != number) continue;
            permanent.destroy(source, game, false);
        }
        FilterCard filterCard = new FilterCard();
        filterCard.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, number));
        filterCard.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer == null) {
            return true;
        }
        targetPlayer.revealCards(source, targetPlayer.getHand(), game);
        targetPlayer.discard((Cards)new CardsImpl(targetPlayer.getHand().getCards(filterCard, game)), false, source, game);
        return true;
    }
}

