/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VoidStalkerEffect
extends OneShotEffect {
    VoidStalkerEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Put {this} and target creature on top of their owners' libraries, then those players shuffle their libraries";
    }

    private VoidStalkerEffect(VoidStalkerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player owner;
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        LinkedHashSet<Player> toShuffle = new LinkedHashSet<Player>();
        if (targetCreature != null && (owner = game.getPlayer(targetCreature.getOwnerId())) != null) {
            owner.putCardsOnTopOfLibrary((Card)targetCreature, game, source, true);
            toShuffle.add(owner);
        }
        if (sourcePermanent != null && (owner = game.getPlayer(sourcePermanent.getOwnerId())) != null) {
            owner.putCardsOnTopOfLibrary((Card)sourcePermanent, game, source, true);
            toShuffle.add(owner);
        }
        for (Player player : toShuffle) {
            player.shuffleLibrary(source, game);
        }
        return true;
    }

    public VoidStalkerEffect copy() {
        return new VoidStalkerEffect(this);
    }
}

