/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetOpponentsChoicePermanent;
import mage.target.targetadjustment.TargetAdjuster;

enum VolcanicOfferingAdjuster implements TargetAdjuster
{
    instance;

    private static final FilterLandPermanent filterLand;

    public void adjustTargets(Ability ability, Game game) {
        Player controller = game.getPlayer(ability.getControllerId());
        if (controller == null) {
            return;
        }
        ability.getTargets().clear();
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)filterLand));
        FilterLandPermanent filterLandForOpponent = new FilterLandPermanent("nonbasic land not controlled by " + controller.getLogName());
        filterLandForOpponent.add(Predicates.not((Predicate)SuperType.BASIC.getPredicate()));
        filterLandForOpponent.add(Predicates.not((Predicate)new ControllerIdPredicate(controller.getId())));
        ability.addTarget((Target)new TargetOpponentsChoicePermanent(1, 1, (FilterPermanent)filterLandForOpponent, false));
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL));
        FilterCreaturePermanent filterCreatureForOpponent = new FilterCreaturePermanent("creature not controlled by " + controller.getLogName());
        filterCreatureForOpponent.add(Predicates.not((Predicate)new ControllerIdPredicate(controller.getId())));
        ability.addTarget((Target)new TargetOpponentsChoicePermanent(1, 1, (FilterPermanent)filterCreatureForOpponent, false));
    }

    static {
        filterLand = new FilterLandPermanent("nonbasic land you don't control");
        filterLand.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getControllerPredicate());
        filterLand.add(Predicates.not((Predicate)SuperType.BASIC.getPredicate()));
    }
}

