/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VolcanoHellionEffect
extends OneShotEffect {
    VolcanoHellionEffect() {
        super(Outcome.Damage);
        this.staticText = "it deals an amount of damage of your choice to you and target creature. The damage can't be prevented";
    }

    private VolcanoHellionEffect(VolcanoHellionEffect effect) {
        super((OneShotEffect)effect);
    }

    public VolcanoHellionEffect copy() {
        return new VolcanoHellionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (controller != null) {
            int amount;
            if (controller.isComputer()) {
                int safeLifeToLost = Math.min(6, controller.getLife() / 2);
                amount = permanent != null && permanent.getToughness().getValue() <= safeLifeToLost ? permanent.getToughness().getValue() : 0;
            } else {
                amount = controller.getAmount(0, Integer.MAX_VALUE, "Choose the amount of damage to deliver to you and a target creature. The damage can't be prevented.", source, game);
            }
            if (amount > 0) {
                controller.damage(amount, source.getSourceId(), source, game, false, false);
                if (permanent != null) {
                    permanent.damage(amount, source.getSourceId(), source, game, false, false);
                }
                return true;
            }
        }
        return false;
    }
}

