/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.ControlEnchantedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class VolitionReins
extends CardImpl {
    public VolitionReins(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{3}{U}{U}{U}");
        this.subtype.add((Object)SubType.AURA);
        TargetPermanent auraTarget = new TargetPermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.GainControl));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new EntersBattlefieldTriggeredAbility((Effect)new UntapVolitionReinsEffect()));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new ControlEnchantedEffect("permanent")));
    }

    private VolitionReins(VolitionReins card) {
        super((CardImpl)card);
    }

    public VolitionReins copy() {
        return new VolitionReins(this);
    }

    public static class UntapVolitionReinsEffect
    extends OneShotEffect {
        public UntapVolitionReinsEffect() {
            super(Outcome.Untap);
            this.staticText = "if enchanted permanent is tapped, untap it";
        }

        private UntapVolitionReinsEffect(UntapVolitionReinsEffect effect) {
            super((OneShotEffect)effect);
        }

        public UntapVolitionReinsEffect copy() {
            return new UntapVolitionReinsEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Permanent permanent;
            Permanent enchantment = game.getPermanent(source.getSourceId());
            if (enchantment != null && enchantment.getAttachedTo() != null && (permanent = game.getPermanent(enchantment.getAttachedTo())) != null && permanent.isTapped()) {
                permanent.untap(game);
                return true;
            }
            return false;
        }
    }
}

