/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.cards.v.VolrathTheShapestealerCopyApplier;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.functions.CopyApplier;

class VolrathTheShapestealerEffect
extends OneShotEffect {
    VolrathTheShapestealerEffect() {
        super(Outcome.Copy);
        this.staticText = "Until your next turn, {this} becomes a copy of target creature with a counter on it, except it's 7/5 and it has this ability.";
    }

    private VolrathTheShapestealerEffect(VolrathTheShapestealerEffect effect) {
        super((OneShotEffect)effect);
    }

    public VolrathTheShapestealerEffect copy() {
        return new VolrathTheShapestealerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent volrathTheShapestealer = game.getPermanent(source.getSourceId());
        if (controller == null || volrathTheShapestealer == null) {
            return false;
        }
        Permanent copyFromCard = game.getPermanent(source.getFirstTarget());
        if (copyFromCard == null) {
            return true;
        }
        Card newBluePrint = copyFromCard.copy();
        newBluePrint.assignNewId();
        VolrathTheShapestealerCopyApplier applier = new VolrathTheShapestealerCopyApplier();
        applier.apply(game, (MageObject)newBluePrint, source, volrathTheShapestealer.getId());
        CopyEffect copyEffect = new CopyEffect(Duration.UntilYourNextTurn, (MageObject)newBluePrint, volrathTheShapestealer.getId());
        copyEffect.setApplier((CopyApplier)applier);
        Ability newAbility = source.copy();
        copyEffect.init(newAbility, game);
        game.addEffect((ContinuousEffect)copyEffect, newAbility);
        return true;
    }
}

