/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.token.VolrathsLaboratoryToken;

class VolrathsLaboratoryEffect
extends OneShotEffect {
    VolrathsLaboratoryEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create a 2/2 creature token of the chosen color and type";
    }

    private VolrathsLaboratoryEffect(VolrathsLaboratoryEffect effect) {
        super((OneShotEffect)effect);
    }

    public VolrathsLaboratoryEffect copy() {
        return new VolrathsLaboratoryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ObjectColor color = (ObjectColor)game.getState().getValue(source.getSourceId() + "_color");
        SubType subType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)source.getSourceId(), (Game)game);
        if (subType == null || color == null) {
            return false;
        }
        return new VolrathsLaboratoryToken(color, subType).putOntoBattlefield(1, game, source, source.getControllerId());
    }
}

