/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DontUntapInControllersNextUntapStepTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class VorinclexTriggeredAbility2
extends TriggeredAbilityImpl {
    VorinclexTriggeredAbility2() {
        super(Zone.BATTLEFIELD, (Effect)new DontUntapInControllersNextUntapStepTargetEffect());
    }

    private VorinclexTriggeredAbility2(VorinclexTriggeredAbility2 ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.inCheckPlayableState()) {
            return false;
        }
        if (!game.getOpponents(this.getControllerId()).contains(event.getPlayerId())) {
            return false;
        }
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        if (permanent == null || !permanent.isLand(game)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        return true;
    }

    public VorinclexTriggeredAbility2 copy() {
        return new VorinclexTriggeredAbility2(this);
    }

    public String getRule() {
        return "Whenever an opponent taps a land for mana, that land doesn't untap during its controller's next untap step.";
    }
}

