/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class VraskaBetrayalsStingEffect
extends OneShotEffect {
    VraskaBetrayalsStingEffect() {
        super(Outcome.Benefit);
        this.staticText = "If target player has fewer than nine poison counters, they get a number of poison counters equal to the difference";
    }

    private VraskaBetrayalsStingEffect(VraskaBetrayalsStingEffect effect) {
        super((OneShotEffect)effect);
    }

    public VraskaBetrayalsStingEffect copy() {
        return new VraskaBetrayalsStingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (targetPlayer == null) {
            return false;
        }
        int totalPoison = targetPlayer.getCountersCount(CounterType.POISON);
        if (totalPoison < 9) {
            targetPlayer.addCounters(CounterType.POISON.createInstance(9 - totalPoison), source.getControllerId(), source, game);
        }
        return true;
    }
}

