/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersAllEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class VraskaRegalGorgonEffect
extends OneShotEffect {
    VraskaRegalGorgonEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each creature card in your graveyard, put a +1/+1 counter on each creature you control.";
    }

    private VraskaRegalGorgonEffect(VraskaRegalGorgonEffect effect) {
        super((OneShotEffect)effect);
    }

    public VraskaRegalGorgonEffect copy() {
        return new VraskaRegalGorgonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int count = player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
        return new AddCountersAllEffect(CounterType.P1P1.createInstance(count), (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE).apply(game, source);
    }
}

