/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class VrenTheRelentlessWatcher
extends Watcher {
    private final Map<UUID, Integer> playerMap = new HashMap<UUID, Integer>();

    VrenTheRelentlessWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE) {
            return;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getToZone() == Zone.EXILED && zEvent.getFromZone() == Zone.BATTLEFIELD && zEvent.getTarget().isCreature(game)) {
            this.playerMap.compute(zEvent.getTarget().getControllerId(), CardUtil::setOrIncrementValue);
        }
    }

    public void reset() {
        this.playerMap.clear();
        super.reset();
    }

    int getCount(UUID playerId, Game game) {
        return game.getOpponents(playerId).stream().mapToInt(uuid -> this.playerMap.getOrDefault(uuid, 0)).sum();
    }
}

