/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.v.VulpineHarvesterEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class VulpineHarvesterTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.PHYREXIAN);

    VulpineHarvesterTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new VulpineHarvesterEffect());
        this.addTarget((Target)new TargetCardInYourGraveyard(StaticFilters.FILTER_CARD_ARTIFACT_FROM_YOUR_GRAVEYARD));
    }

    private VulpineHarvesterTriggeredAbility(VulpineHarvesterTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public VulpineHarvesterTriggeredAbility copy() {
        return new VulpineHarvesterTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        List permanents = game.getCombat().getAttackers().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(permanent -> filter.match(permanent, this.getControllerId(), (Ability)this, game)).collect(Collectors.toList());
        if (permanents.size() > 0) {
            this.getEffects().setValue("attackers", permanents);
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever one or more Phyrexians you control attack, return target artifact card from your graveyard to the battlefield if its mana value is less than or equal to their total power.";
    }
}

