/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class VulshokGauntletsEffect
extends ReplacementEffectImpl {
    VulshokGauntletsEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Equipped creature doesn't untap during its controller's untap step";
    }

    private VulshokGauntletsEffect(VulshokGauntletsEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public VulshokGauntletsEffect copy() {
        return new VulshokGauntletsEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAP;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent equipped;
        Permanent equipment;
        return game.getTurnStepType() == PhaseStep.UNTAP && (equipment = game.getPermanent(source.getSourceId())) != null && equipment.getAttachedTo() != null && (equipped = game.getPermanent(equipment.getAttachedTo())).getId().equals(event.getTargetId());
    }
}

