/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class BlockedOrBeenBlockedSinceYourLastUpkeepWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> blockedOrBeenBlockedCreatures = new HashMap<UUID, Set<MageObjectReference>>();

    public BlockedOrBeenBlockedSinceYourLastUpkeepWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.UPKEEP_STEP_POST) {
            this.blockedOrBeenBlockedCreatures.put(event.getPlayerId(), new HashSet());
        } else if (event.getType() == GameEvent.EventType.BLOCKER_DECLARED) {
            MageObjectReference morBlocker = new MageObjectReference(event.getSourceId(), game);
            MageObjectReference morAttackerBlocked = new MageObjectReference(event.getTargetId(), game);
            for (UUID player : game.getPlayerList()) {
                if (!this.blockedOrBeenBlockedCreatures.containsKey(player)) {
                    this.blockedOrBeenBlockedCreatures.put(player, new HashSet());
                }
                this.blockedOrBeenBlockedCreatures.get(player).add(morBlocker);
                this.blockedOrBeenBlockedCreatures.get(player).add(morAttackerBlocked);
            }
        }
    }

    public boolean blockedOrBeenBlockedSinceLastUpkeep(MageObjectReference mor, UUID player) {
        return this.blockedOrBeenBlockedCreatures.get(player) != null && this.blockedOrBeenBlockedCreatures.get(player).contains(mor);
    }
}

