/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Mode;
import mage.constants.SubType;
import mage.filter.Filter;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.target.Target;

enum CanTargetOnlyWallsPredicate implements Predicate<MageObject>
{
    instance;


    public boolean apply(MageObject input, Game game) {
        Spell stackObject = game.getStack().getSpell(input.getId());
        if (stackObject == null) {
            return false;
        }
        boolean canTargetOnlyWalls = false;
        for (UUID modeId : stackObject.getStackAbility().getModes().getSelectedModes()) {
            Mode mode = stackObject.getStackAbility().getModes().get((Object)modeId);
            for (Target target : mode.getTargets()) {
                Filter filter = target.getFilter();
                if (!(filter instanceof FilterPermanent)) {
                    return false;
                }
                for (Object predicate : filter.getPredicates()) {
                    if (!(predicate instanceof SubType.SubTypePredicate)) continue;
                    if (predicate.toString().equals("Subtype(Wall)")) {
                        canTargetOnlyWalls = true;
                        continue;
                    }
                    return false;
                }
            }
        }
        return canTargetOnlyWalls;
    }

    public String toString() {
        return "can target only Walls";
    }
}

