/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.w.ExploreTheVastlandsTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class ExploreTheVastlandsEffect
extends OneShotEffect {
    ExploreTheVastlandsEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player looks at the top five cards of their library and may reveal a land card and/or an instant or sorcery card from among them. Each player puts the cards they revealed this way into their hand and the rest on the bottom of their library in a random order.";
    }

    private ExploreTheVastlandsEffect(ExploreTheVastlandsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExploreTheVastlandsEffect copy() {
        return new ExploreTheVastlandsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 5));
            ExploreTheVastlandsTarget target = new ExploreTheVastlandsTarget();
            player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
            CardsImpl toHand = new CardsImpl((Collection)target.getTargets());
            cards.removeIf(target.getTargets()::contains);
            player.revealCards(source, (Cards)toHand, game);
            player.moveCards((Cards)toHand, Zone.HAND, source, game);
            player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        return true;
    }
}

