/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class WakeThePastEffect
extends OneShotEffect {
    WakeThePastEffect() {
        super(Outcome.Benefit);
        this.staticText = "return all artifact cards from your graveyard to the battlefield. They gain haste until end of turn";
    }

    private WakeThePastEffect(WakeThePastEffect effect) {
        super((OneShotEffect)effect);
    }

    public WakeThePastEffect copy() {
        return new WakeThePastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT, game));
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
        cards.removeIf(uuid -> game.getState().getZone(uuid) != Zone.BATTLEFIELD);
        if (cards.isEmpty()) {
            return true;
        }
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets((Cards)cards, game)), source);
        return true;
    }
}

