/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class WakeToSlaughterEffect
extends OneShotEffect {
    WakeToSlaughterEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose up to two target creature cards in your graveyard. An opponent chooses one of them. Return that card to your hand. Return the other to the battlefield under your control. It gains haste. Exile it at the beginning of the next end step.";
    }

    public WakeToSlaughterEffect(WakeToSlaughterEffect effect) {
        super((OneShotEffect)effect);
    }

    public WakeToSlaughterEffect copy() {
        return new WakeToSlaughterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        CardsImpl pickedCards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        if (player != null && !pickedCards.isEmpty()) {
            Card cardToHand;
            if (pickedCards.size() == 1) {
                cardToHand = pickedCards.getRandom(game);
            } else {
                Player opponent;
                Set opponents = game.getOpponents(player.getId());
                if (opponents.size() == 1) {
                    opponent = game.getPlayer((UUID)opponents.iterator().next());
                } else {
                    TargetOpponent targetOpponent = new TargetOpponent(true);
                    player.chooseTarget(Outcome.Detriment, (Target)targetOpponent, source, game);
                    opponent = game.getPlayer(targetOpponent.getFirstTarget());
                }
                TargetCard target = new TargetCard(1, Zone.GRAVEYARD, new FilterCard());
                target.withChooseHint("Card to go to opponent's hand (other goes to battlefield)");
                opponent.chooseTarget(this.outcome, (Cards)pickedCards, target, source, game);
                cardToHand = game.getCard(target.getFirstTarget());
            }
            for (Card card : pickedCards.getCards(game)) {
                if (card == cardToHand) {
                    player.moveCards(cardToHand, Zone.HAND, source, game);
                    continue;
                }
                player.moveCards(card, Zone.BATTLEFIELD, source, game);
                FixedTarget blueprintTarget = new FixedTarget(card, game);
                GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfGame);
                effect.setTargetPointer((TargetPointer)blueprintTarget.copy());
                game.addEffect((ContinuousEffect)effect, source);
                ExileTargetEffect exileEffect = new ExileTargetEffect(null, null, Zone.BATTLEFIELD);
                exileEffect.setTargetPointer((TargetPointer)blueprintTarget.copy());
                AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)exileEffect);
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            }
            pickedCards.clear();
            return true;
        }
        return false;
    }
}

