/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.TrollWarriorToken;

class WakingTheTrollsEffect
extends OneShotEffect {
    WakingTheTrollsEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target opponent. If they control fewer lands than you, create a number of 4/4 green Troll Warrior creature tokens with trample equal to the difference";
    }

    private WakingTheTrollsEffect(WakingTheTrollsEffect effect) {
        super((OneShotEffect)effect);
    }

    public WakingTheTrollsEffect copy() {
        return new WakingTheTrollsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int theirLands;
        int myLands = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, source.getControllerId(), source, game);
        if (myLands <= (theirLands = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, source.getFirstTarget(), source, game))) {
            return false;
        }
        return new TrollWarriorToken().putOntoBattlefield(myLands - theirLands, game, source, source.getControllerId());
    }
}

