/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.AttacksIfAbleAllEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class WalkingDesecrationEffect
extends OneShotEffect {
    WalkingDesecrationEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "Creatures of the creature type of your choice attack this turn if able";
    }

    private WalkingDesecrationEffect(WalkingDesecrationEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        ChoiceCreatureType typeChoice;
        Player player = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (player != null && sourceObject != null && player.choose(this.outcome, (Choice)(typeChoice = new ChoiceCreatureType(game, source)), game)) {
            game.informPlayers(sourceObject.getLogName() + " chosen type: " + typeChoice.getChoiceKey());
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)SubType.byDescription((String)typeChoice.getChoiceKey()).getPredicate());
            AttacksIfAbleAllEffect effect = new AttacksIfAbleAllEffect((FilterPermanent)filter, Duration.EndOfTurn);
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }

    public WalkingDesecrationEffect copy() {
        return new WalkingDesecrationEffect(this);
    }
}

