/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Objects;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.OpponentsCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class WallOfMourningExileEffect
extends OneShotEffect {
    WallOfMourningExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile a card from the top of your library face down for each opponent you have";
    }

    private WallOfMourningExileEffect(WallOfMourningExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public WallOfMourningExileEffect copy() {
        return new WallOfMourningExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int opponents = OpponentsCount.instance.calculate(game, source, (Effect)this);
        Set cards = player.getLibrary().getTopCards(game, opponents);
        cards.removeIf(Objects::isNull);
        player.moveCardsToExile(cards, source, game, false, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        for (Card card : cards) {
            card.setFaceDown(true, game);
        }
        return true;
    }
}

