/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class WallOfMourningReturnEffect
extends OneShotEffect {
    WallOfMourningReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a card exiled with {this} into its owner's hand";
    }

    private WallOfMourningReturnEffect(WallOfMourningReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public WallOfMourningReturnEffect copy() {
        return new WallOfMourningReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        return player.moveCards(exileZone.getRandom(game), Zone.HAND, source, game);
    }
}

