/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WallOfReverenceTriggeredEffect
extends OneShotEffect {
    WallOfReverenceTriggeredEffect() {
        super(Outcome.GainLife);
        this.staticText = "gain life equal to the power of target creature you control";
    }

    private WallOfReverenceTriggeredEffect(WallOfReverenceTriggeredEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        Player player = game.getPlayer(source.getControllerId());
        if (target != null && player != null) {
            player.gainLife(target.getPower().getValue(), game, source);
            return true;
        }
        return false;
    }

    public WallOfReverenceTriggeredEffect copy() {
        return new WallOfReverenceTriggeredEffect(this);
    }
}

