/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DontUntapInControllersUntapStepTargetEffect;
import mage.abilities.effects.common.TapTargetEffect;
import mage.abilities.keyword.DefenderAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.functions.CopyApplier;

class WallOfStolenIdentityCopyEffect
extends OneShotEffect {
    private static final String rule2 = "When you do, .";

    public WallOfStolenIdentityCopyEffect() {
        super(Outcome.Copy);
        this.staticText = rule2;
    }

    private WallOfStolenIdentityCopyEffect(WallOfStolenIdentityCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            permanent = game.getPermanentEntering(source.getSourceId());
        }
        Permanent sourcePermanent = permanent;
        if (controller == null || sourcePermanent == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent((FilterPermanent)new FilterCreaturePermanent("target creature (you copy from)"));
        target.setRequired(true);
        if (source instanceof SimpleStaticAbility) {
            target = new TargetPermanent((FilterPermanent)new FilterCreaturePermanent("creature (you copy from)"));
            target.setRequired(false);
            target.withNotTarget(true);
        }
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        controller.choose(Outcome.Copy, (Target)target, source, game);
        Permanent copyFromPermanent = game.getPermanent(target.getFirstTarget());
        if (copyFromPermanent == null) {
            return false;
        }
        game.copyPermanent(copyFromPermanent, sourcePermanent.getId(), source, new CopyApplier(){

            public boolean apply(Game game, MageObject blueprint, Ability source, UUID copyToObjectId) {
                blueprint.addSubType(new SubType[]{SubType.WALL});
                blueprint.getAbilities().add((Object)DefenderAbility.getInstance());
                return true;
            }
        });
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new TapTargetEffect(), false, "tap the copied creature and it doesn't untap during its controller's untap step for as long as you control {this}");
        ability.addEffect((Effect)new DontUntapInControllersUntapStepTargetEffect(Duration.WhileControlled));
        ability.getEffects().setTargetPointer((TargetPointer)new FixedTarget(copyFromPermanent, game));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    public WallOfStolenIdentityCopyEffect copy() {
        return new WallOfStolenIdentityCopyEffect(this);
    }
}

