/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class WarBargeDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    WarBargeDelayedTriggeredAbility() {
        super((Effect)new DestroyTargetEffect(true), Duration.EndOfTurn, false);
    }

    private WarBargeDelayedTriggeredAbility(WarBargeDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public WarBargeDelayedTriggeredAbility copy() {
        return new WarBargeDelayedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        if (event.getTargetId().equals(this.getSourceId()) && (zEvent = (ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD) {
            Effect effect = (Effect)this.getEffects().get(0);
            effect.setTargetPointer((TargetPointer)new FixedTarget(this.getFirstTarget()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "When {this} leaves the battlefield this turn, destroy that creature. A creature destroyed this way can't be regenerated.";
    }
}

