/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.HashSet;
import java.util.Set;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class WarHistorianWatcher
extends Watcher {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    WarHistorianWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ATTACKER_DECLARED) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isBattle(game)) {
            this.morSet.add(new MageObjectReference(event.getSourceId(), game));
        }
    }

    public void reset() {
        super.reset();
        this.morSet.clear();
    }

    static boolean checkPermanent(Ability source, Game game) {
        return ((WarHistorianWatcher)game.getState().getWatcher(WarHistorianWatcher.class)).morSet.stream().anyMatch(mor -> mor.refersTo(source.getSourceId(), game));
    }
}

