/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterArtifactPermanent;
import mage.game.Game;
import mage.players.Player;

class WarReportEffect
extends OneShotEffect {
    WarReportEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain life equal to the number of creatures on the battlefield plus the number of artifacts on the battlefield";
    }

    private WarReportEffect(WarReportEffect effect) {
        super((OneShotEffect)effect);
    }

    public WarReportEffect copy() {
        return new WarReportEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            int lifeToGain = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game);
            player.gainLife(lifeToGain += game.getBattlefield().count((FilterPermanent)new FilterArtifactPermanent(), source.getControllerId(), source, game), game, source);
        }
        return true;
    }
}

