/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;

class WardOfPietyPreventDamageTargetEffect
extends RedirectionEffect {
    protected MageObjectReference redirectToObject;

    public WardOfPietyPreventDamageTargetEffect() {
        super(Duration.EndOfTurn, 1, RedirectionEffect.UsageType.ONE_USAGE_ABSOLUTE);
        this.staticText = "The next 1 damage that would be dealt to enchanted creature this turn is dealt to any target instead";
    }

    private WardOfPietyPreventDamageTargetEffect(WardOfPietyPreventDamageTargetEffect effect) {
        super((RedirectionEffect)effect);
        this.redirectToObject = effect.redirectToObject;
    }

    public WardOfPietyPreventDamageTargetEffect copy() {
        return new WardOfPietyPreventDamageTargetEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.redirectToObject = new MageObjectReference(((Target)source.getTargets().get(0)).getFirstTarget(), game);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment != null && event.getTargetId().equals(enchantment.getAttachedTo()) && this.redirectToObject.equals((Object)new MageObjectReference(((Target)source.getTargets().get(0)).getFirstTarget(), game))) {
            this.redirectTarget = (Target)source.getTargets().get(0);
            return true;
        }
        return false;
    }
}

