/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.keyword.DefenderAbility;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WarmongersChariotEffect
extends AsThoughEffectImpl {
    WarmongersChariotEffect() {
        super(AsThoughEffectType.ATTACK, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "As long as equipped creature has defender, it can attack as though it didn't have defender";
    }

    private WarmongersChariotEffect(WarmongersChariotEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public WarmongersChariotEffect copy() {
        return new WarmongersChariotEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Permanent creature;
        Permanent equipment = game.getPermanent(source.getSourceId());
        return equipment != null && equipment.getAttachedTo() != null && (creature = game.getPermanent(equipment.getAttachedTo())) != null && creature.getId().equals(sourceId) && creature.getAbilities().containsKey(DefenderAbility.getInstance().getId());
    }
}

