/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class WarpWorldEffect
extends OneShotEffect {
    WarpWorldEffect() {
        super(Outcome.Neutral);
        this.staticText = "Each player shuffles all permanents they own into their library, then reveals that many cards from the top of their library. Each player puts all artifact, creature, and land cards revealed this way onto the battlefield, then does the same for enchantment cards, then puts all cards revealed this way that weren't put onto the battlefield on the bottom of their library";
    }

    private WarpWorldEffect(WarpWorldEffect effect) {
        super((OneShotEffect)effect);
    }

    public WarpWorldEffect copy() {
        return new WarpWorldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CardsImpl cards;
        HashSet<Card> toBattlefield;
        CardsImpl cards2;
        Player player;
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject == null) {
            return false;
        }
        HashMap<UUID, LinkedHashSet<Object>> permanentsOwned = new HashMap<UUID, LinkedHashSet<Object>>();
        List permanents = game.getBattlefield().getAllActivePermanents();
        for (Object permanent : permanents) {
            LinkedHashSet<Object> set = (LinkedHashSet<Object>)permanentsOwned.get(permanent.getOwnerId());
            if (set == null) {
                set = new LinkedHashSet<Object>();
            }
            set.add(permanent);
            permanentsOwned.put(permanent.getOwnerId(), set);
        }
        HashMap<UUID, Integer> permanentsCount = new HashMap<UUID, Integer>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player2 = game.getPlayer(playerId);
            if (player2 == null) continue;
            Set set = (Set)permanentsOwned.remove(playerId);
            Integer count = 0;
            if (set != null) {
                count = set.size();
                player2.moveCards(set, Zone.LIBRARY, source, game);
            }
            if (count > 0) {
                player2.shuffleLibrary(source, game);
            }
            permanentsCount.put(playerId, count);
        }
        game.processAction();
        HashMap<UUID, CardsImpl> cardsRevealed = new HashMap<UUID, CardsImpl>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            cards2 = new CardsImpl();
            cards2.addAllCards((Collection)player.getLibrary().getTopCards(game, ((Integer)permanentsCount.get(player.getId())).intValue()));
            player.revealCards(sourceObject.getIdName() + " (" + player.getName() + ')', (Cards)cards2, game);
            cardsRevealed.put(player.getId(), cards2);
        }
        game.processAction();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            toBattlefield = new HashSet<Card>();
            cards = (CardsImpl)cardsRevealed.get(player.getId());
            for (Card card : cards.getCards(game)) {
                if (card == null || !card.isArtifact(game) && !card.isCreature(game) && !card.isLand(game)) continue;
                toBattlefield.add(card);
                cards.remove(card);
            }
            player.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game);
        }
        game.processAction();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            toBattlefield = new HashSet();
            cards = (CardsImpl)cardsRevealed.get(player.getId());
            for (Card card : cards.getCards(game)) {
                if (card == null || !card.isEnchantment(game)) continue;
                toBattlefield.add(card);
                cards.remove(card);
            }
            player.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game);
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            cards2 = (CardsImpl)cardsRevealed.get(player.getId());
            player.putCardsOnBottomOfLibrary((Cards)cards2, game, source, false);
        }
        return true;
    }
}

