/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CounterTargetEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.filter.FilterSpell;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.filter.predicate.mageobject.ToughnessPredicate;
import mage.game.permanent.token.EldraziScionToken;
import mage.game.permanent.token.Token;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.TargetSpell;

public final class WarpingWail
extends CardImpl {
    private static final FilterCreaturePermanent filterCreature = new FilterCreaturePermanent("creature with power or toughness 1 or less");
    private static final FilterSpell filterSorcery = new FilterSpell("sorcery spell");

    public WarpingWail(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{1}{C}");
        ExileTargetEffect effect = new ExileTargetEffect();
        effect.setText("Exile target creature with power or toughness 1 or less.");
        this.getSpellAbility().addEffect((Effect)effect);
        this.getSpellAbility().addTarget((Target)new TargetPermanent((FilterPermanent)filterCreature));
        Mode mode = new Mode((Effect)new CounterTargetEffect());
        mode.addTarget((Target)new TargetSpell(filterSorcery));
        this.getSpellAbility().addMode(mode);
        effect = new CreateTokenEffect((Token)new EldraziScionToken()).withTextOptions(true);
        this.getSpellAbility().addMode(new Mode((Effect)effect));
    }

    private WarpingWail(WarpingWail card) {
        super((CardImpl)card);
    }

    public WarpingWail copy() {
        return new WarpingWail(this);
    }

    static {
        filterCreature.add(Predicates.or((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, 2), (Predicate)new ToughnessPredicate(ComparisonType.FEWER_THAN, 2)));
        filterSorcery.add((Predicate)CardType.SORCERY.getPredicate());
    }
}

