/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.w.WarstormSurgeEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class WarstormSurgeTriggeredAbility
extends TriggeredAbilityImpl {
    public WarstormSurgeTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new WarstormSurgeEffect(), false);
    }

    private WarstormSurgeTriggeredAbility(WarstormSurgeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isCreature(game) && permanent.isControlledBy(this.controllerId)) {
            Effect effect = (Effect)this.getEffects().get(0);
            effect.setValue("damageSource", (Object)event.getTargetId());
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature you control enters, it deals damage equal to its power to any target.";
    }

    public WarstormSurgeTriggeredAbility copy() {
        return new WarstormSurgeTriggeredAbility(this);
    }
}

