/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class WaterspoutWardenWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> map = new HashMap<UUID, Set<MageObjectReference>>();

    WaterspoutWardenWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null) {
            this.map.computeIfAbsent(permanent.getControllerId(), x -> new HashSet()).add(new MageObjectReference((MageObject)permanent, game));
        }
    }

    public void reset() {
        this.map.clear();
        super.reset();
    }

    static boolean checkPermanent(Game game, Ability source) {
        return ((WaterspoutWardenWatcher)game.getState().getWatcher(WaterspoutWardenWatcher.class)).map.getOrDefault(source.getControllerId(), Collections.emptySet()).stream().anyMatch(mor -> !mor.refersTo(source, game));
    }
}

