/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.CostAdjuster;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.util.CardUtil;

enum WaytaTrainerProdigyAdjuster implements CostAdjuster
{
    instance;


    public void reduceCost(Ability ability, Game game) {
        if (game.inCheckPlayableState()) {
            int controllerTargets = 0;
            for (UUID permId : CardUtil.getAllPossibleTargets((Ability)ability, (Game)game)) {
                Permanent permanent = game.getPermanent(permId);
                if (permanent == null || !permanent.isControlledBy(ability.getControllerId())) continue;
                ++controllerTargets;
            }
            if (controllerTargets > 1) {
                CardUtil.reduceCost((Ability)ability, (int)2);
            }
        } else {
            Target secondTarget = null;
            for (Target target : ability.getTargets()) {
                if (target.getTargetTag() != 2) continue;
                secondTarget = target;
                break;
            }
            if (secondTarget == null) {
                return;
            }
            Permanent permanent = game.getPermanentOrLKIBattlefield(secondTarget.getFirstTarget());
            if (permanent != null && permanent.isControlledBy(ability.getControllerId())) {
                CardUtil.reduceCost((Ability)ability, (int)2);
            }
        }
    }
}

