/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class WaywardGuideBeastEffect
extends OneShotEffect {
    WaywardGuideBeastEffect() {
        super(Outcome.Benefit);
        this.staticText = "return a land you control to its owner's hand";
    }

    private WaywardGuideBeastEffect(WaywardGuideBeastEffect effect) {
        super((OneShotEffect)effect);
    }

    public WaywardGuideBeastEffect copy() {
        return new WaywardGuideBeastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, source.getControllerId(), source, game) == 0) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, true);
        player.choose(this.outcome, (Target)target, source, game);
        player.moveCards(game.getCard(target.getFirstTarget()), Zone.HAND, source, game);
        return true;
    }
}

