/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Iterator;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.hint.Hint;
import mage.cards.w.WeatheredSentinelsLastTurnAttackersWatcher;
import mage.game.Game;
import mage.players.Player;

enum WeatheredSentinelsPlayersWhoAttackedYouLastTurn implements Hint
{
    instance;


    public String getText(Game game, Ability ability) {
        Player controller = game.getPlayer(ability.getControllerId());
        WeatheredSentinelsLastTurnAttackersWatcher watcher = (WeatheredSentinelsLastTurnAttackersWatcher)game.getState().getWatcher(WeatheredSentinelsLastTurnAttackersWatcher.class);
        if (controller == null || watcher == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("Attacked you on their last turn: ");
        Iterator opponentIdIterator = game.getOpponents(controller.getId()).iterator();
        while (opponentIdIterator.hasNext()) {
            UUID opponentId = (UUID)opponentIdIterator.next();
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || !watcher.checkPlayer(opponentId, controller.getId())) continue;
            stringBuilder.append(opponent.getName());
            if (opponentIdIterator.hasNext()) {
                stringBuilder.append(", ");
                continue;
            }
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    public Hint copy() {
        return instance;
    }
}

