/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.w.WebOfInertiaRestrictionEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInYourGraveyard;

class WebOfInertiaEffect
extends OneShotEffect {
    WebOfInertiaEffect() {
        super(Outcome.Detriment);
        this.staticText = "that player may exile a card from their graveyard. If the player doesn't, creatures they control can't attack you this turn";
    }

    private WebOfInertiaEffect(WebOfInertiaEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = game.getObject(source);
        if (player != null && sourceObject != null) {
            ExileFromGraveCost cost = new ExileFromGraveCost(new TargetCardInYourGraveyard());
            if (cost.canPay(source, source, player.getId(), game) && player.chooseUse(Outcome.Detriment, "Exile a card from your graveyard?", source, game)) {
                cost.clearPaid();
                if (cost.pay(source, game, source, player.getId(), false, null)) {
                    game.informPlayers(player.getLogName() + " pays the cost to prevent the effect");
                }
            } else {
                game.addEffect((ContinuousEffect)new WebOfInertiaRestrictionEffect(player.getId()), source);
            }
            return true;
        }
        return false;
    }

    public WebOfInertiaEffect copy() {
        return new WebOfInertiaEffect(this);
    }
}

