/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.SpellsCastWatcher;

class WeftwalkingEffect
extends ContinuousEffectImpl {
    private final AlternativeCostSourceAbility alternativeCastingCostAbility;

    WeftwalkingEffect() {
        super(Duration.WhileOnBattlefield, Layer.RulesEffects, SubLayer.NA, Outcome.PlayForFree);
        this.alternativeCastingCostAbility = new AlternativeCostSourceAbility(null, (Condition)WeftwalkingCondition.instance, null, (FilterCard)StaticFilters.FILTER_CARD_NON_LAND, true);
        this.staticText = "the first spell each player casts during each of their turns may be cast without paying its mana cost";
    }

    private WeftwalkingEffect(WeftwalkingEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.alternativeCastingCostAbility = effect.alternativeCastingCostAbility;
    }

    public WeftwalkingEffect copy() {
        return new WeftwalkingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player == null) {
            return false;
        }
        this.alternativeCastingCostAbility.setSourceId(source.getSourceId());
        player.getAlternativeSourceCosts().add(this.alternativeCastingCostAbility);
        return true;
    }

    private static enum WeftwalkingCondition implements Condition
    {
        instance;


        public boolean apply(Game game, Ability source) {
            return ((SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class)).getSpellsCastThisTurn(game.getActivePlayerId()).isEmpty();
        }
    }
}

