/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.SharesCreatureTypePredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetControlledPermanent;

class WeightOfConscienceTarget
extends TargetControlledPermanent {
    private static final FilterControlledPermanent filterUntapped = new FilterControlledCreaturePermanent("untapped creatures you control that share a creature type");

    WeightOfConscienceTarget() {
        super(2, 2, filterUntapped, true);
    }

    private WeightOfConscienceTarget(WeightOfConscienceTarget target) {
        super((TargetControlledPermanent)target);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        Player player = game.getPlayer(sourceControllerId);
        if (player == null) {
            return possibleTargets;
        }
        if (this.getTargets().isEmpty()) {
            List permanentList = game.getBattlefield().getActivePermanents((FilterPermanent)filterUntapped, sourceControllerId, source, game);
            if (permanentList.size() < 2) {
                return possibleTargets;
            }
            for (Permanent permanent : permanentList) {
                if (permanent.isAllCreatureTypes(game)) {
                    possibleTargets.add(permanent.getId());
                    continue;
                }
                FilterControlledPermanent filter = filterUntapped.copy();
                filter.add((Predicate)new SharesCreatureTypePredicate(permanent));
                if (game.getBattlefield().count((FilterPermanent)filter, sourceControllerId, source, game) <= 1) continue;
                possibleTargets.add(permanent.getId());
            }
        } else {
            Permanent firstTargetCreature = game.getPermanent(this.getFirstTarget());
            if (firstTargetCreature == null) {
                return possibleTargets;
            }
            FilterControlledPermanent filter = filterUntapped.copy();
            filter.add((Predicate)new SharesCreatureTypePredicate(firstTargetCreature));
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filterUntapped, sourceControllerId, source, game)) {
                if (permanent == null) continue;
                possibleTargets.add(permanent.getId());
            }
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    public WeightOfConscienceTarget copy() {
        return new WeightOfConscienceTarget(this);
    }

    static {
        filterUntapped.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

